/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.humanoid;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class HaulingComponent
implements EntityComponent {
    private Entity hauledItem;

    public Entity getHauledItem() {
        return this.hauledItem;
    }

    public void setHauledItem(Entity hauledItem, MessageDispatcher messageDispatcher) {
        this.hauledItem = hauledItem;
        EntityAttributes attributes = hauledItem.getPhysicalEntityComponent().getAttributes();
        if (attributes instanceof ItemEntityAttributes) {
            ItemEntityAttributes itemAttributes = (ItemEntityAttributes)attributes;
            itemAttributes.setItemPlacement(ItemPlacement.BEING_CARRIED);
            messageDispatcher.dispatchMessage(324, hauledItem);
        }
    }

    public void clearHauledItem() {
        this.hauledItem = null;
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        HaulingComponent clonedComponent = new HaulingComponent();
        if (this.hauledItem != null) {
            clonedComponent.setHauledItem(this.hauledItem.clone(messageDispatcher, tiledMap), messageDispatcher);
        }
        return clonedComponent;
    }
}

